package GUI;

import java.awt.*;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JOptionPane;

import baseClass.Arquivo;

/**
 *
 * @author kaiooliveira
 */
public class janelaCadastroNome extends javax.swing.JFrame {
	
	private static String arqEstabelecimentos;
	private static String arqOpinioes;
	
	/**
	 * Leitura da lista de usuarios
	 * @param arquivo
	 * 		caminho do arquivo
	 * @return
	 * 		nome dos usuarios
	 */
	public ArrayList<String> retornaListaUsuarios(String arquivo) {

		Arquivo a = new Arquivo();
		try {
			a.lerArquivo(arqOpinioes);
		} catch (Exception e) {
			e.printStackTrace();
		}
		ArrayList<String> nomeDosUsuarios = new ArrayList<String>();
		for (int i = 1; i < a.getLinhasDoArquivoLido().size(); i++) {

			nomeDosUsuarios.add(a.getLinhasDoArquivoLido().get(i).split(";")[1]);
		}
		return nomeDosUsuarios;

	}
	
	/**
	 * Construtor da janela
	 * @param rest
	 * 		caminho do arquivo
	 * @param opini
	 * 		caminho do arquivo
	 */
	public janelaCadastroNome(String rest, String opini) {
		this.arqEstabelecimentos = rest;
		this.arqOpinioes = opini;
		initComponents();
	}

    /**
     * Inicia os componentes da janela
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {

        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jTextField1 = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        
        jLabel2.setText("   Nome do usuario");
        jLabel2.setFont(new java.awt.Font("Lucida Grande", 0, 20));
        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        
        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v4.png"))); // NOI18N
        
        jButton1.setText("Avancar");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jButton2.setText("Voltar");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jTextField1.setText("Informe aqui o seu nome.");
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });
        jTextField1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextField1FocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextField1FocusLost(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(109, 109, 109)
                .add(jButton2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 210, Short.MAX_VALUE)
                .add(jButton1)
                .add(120, 120, 120))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jTextField1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 574, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(226, 226, 226)
                .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 153, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 150, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(77, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(210, 210, 210)
                .add(jLabel2)
                .addContainerGap(214, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2)
                .add(66, 66, 66)
                .add(jTextField1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 163, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jButton2)
                            .add(jButton1))
                        .add(18, 18, 18)
                        .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 48, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 48, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(29, 29, 29))))
        );

        pack();
    }

    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {
    }

    /**
     * @param evt
     */
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {
    	
    	this.dispose();
    	new MenuPrincipal(arqEstabelecimentos, arqOpinioes).setVisible(true);
    	
    }

    /**
     * @param evt
     */
    private void jTextField1FocusGained(java.awt.event.FocusEvent evt){
        if (jTextField1.getText().equalsIgnoreCase("Informe aqui o seu nome.")){
        	jTextField1.setText("");
        }
    }
    
    /**
     * @param evt
     */
    private void jTextField1FocusLost(java.awt.event.FocusEvent evt){
    	if (jTextField1.getText().equalsIgnoreCase("")){
        	jTextField1.setText("Informe aqui o seu nome.");
        }
    }
    /**
     * @param evt
     */
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {
    	
    	if ((jTextField1.getText().equals("")) || (jTextField1.getText().equals("Informe aqui o seu nome.")) || retornaListaUsuarios(arqOpinioes).contains(jTextField1.getText())) {
    		Toolkit.getDefaultToolkit().beep();
    		JOptionPane.showMessageDialog(null, "Nome Inválido ou nome está contido na lista de usuários.");

		} else {

			opinioes[0] = (jTextField1.getText());
			this.dispose();
			new janelaCadastroVotos(arqEstabelecimentos, arqOpinioes)
					.setVisible(true);
		}
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
            	new janelaCadastroNome(arqEstabelecimentos, arqOpinioes).setVisible(true);
            }
        });
    }
    
    public static Object[] getOpinioes() {
		return opinioes;
	}
    
	static Object[] opinioes = new Object[2];
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
}
